import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ImportKeyPairRequest, ImportKeyPairResult } from "../models/models_5";
import { deserializeAws_ec2ImportKeyPairCommand, serializeAws_ec2ImportKeyPairCommand } from "../protocols/Aws_ec2";
var ImportKeyPairCommand = (function (_super) {
    __extends(ImportKeyPairCommand, _super);
    function ImportKeyPairCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ImportKeyPairCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ImportKeyPairCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ImportKeyPairRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ImportKeyPairResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ImportKeyPairCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ImportKeyPairCommand(input, context);
    };
    ImportKeyPairCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ImportKeyPairCommand(output, context);
    };
    return ImportKeyPairCommand;
}($Command));
export { ImportKeyPairCommand };
