import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ImportInstanceRequest, ImportInstanceResult } from "../models/models_5";
import { deserializeAws_ec2ImportInstanceCommand, serializeAws_ec2ImportInstanceCommand } from "../protocols/Aws_ec2";
var ImportInstanceCommand = (function (_super) {
    __extends(ImportInstanceCommand, _super);
    function ImportInstanceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ImportInstanceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ImportInstanceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ImportInstanceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ImportInstanceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ImportInstanceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ImportInstanceCommand(input, context);
    };
    ImportInstanceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ImportInstanceCommand(output, context);
    };
    return ImportInstanceCommand;
}($Command));
export { ImportInstanceCommand };
