import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ImportClientVpnClientCertificateRevocationListRequest, ImportClientVpnClientCertificateRevocationListResult, } from "../models/models_5";
import { deserializeAws_ec2ImportClientVpnClientCertificateRevocationListCommand, serializeAws_ec2ImportClientVpnClientCertificateRevocationListCommand, } from "../protocols/Aws_ec2";
var ImportClientVpnClientCertificateRevocationListCommand = (function (_super) {
    __extends(ImportClientVpnClientCertificateRevocationListCommand, _super);
    function ImportClientVpnClientCertificateRevocationListCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ImportClientVpnClientCertificateRevocationListCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ImportClientVpnClientCertificateRevocationListCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ImportClientVpnClientCertificateRevocationListRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ImportClientVpnClientCertificateRevocationListResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ImportClientVpnClientCertificateRevocationListCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ImportClientVpnClientCertificateRevocationListCommand(input, context);
    };
    ImportClientVpnClientCertificateRevocationListCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ImportClientVpnClientCertificateRevocationListCommand(output, context);
    };
    return ImportClientVpnClientCertificateRevocationListCommand;
}($Command));
export { ImportClientVpnClientCertificateRevocationListCommand };
