import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetTransitGatewayRouteTablePropagationsRequest, GetTransitGatewayRouteTablePropagationsResult, } from "../models/models_5";
import { deserializeAws_ec2GetTransitGatewayRouteTablePropagationsCommand, serializeAws_ec2GetTransitGatewayRouteTablePropagationsCommand, } from "../protocols/Aws_ec2";
var GetTransitGatewayRouteTablePropagationsCommand = (function (_super) {
    __extends(GetTransitGatewayRouteTablePropagationsCommand, _super);
    function GetTransitGatewayRouteTablePropagationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetTransitGatewayRouteTablePropagationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetTransitGatewayRouteTablePropagationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetTransitGatewayRouteTablePropagationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetTransitGatewayRouteTablePropagationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetTransitGatewayRouteTablePropagationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetTransitGatewayRouteTablePropagationsCommand(input, context);
    };
    GetTransitGatewayRouteTablePropagationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetTransitGatewayRouteTablePropagationsCommand(output, context);
    };
    return GetTransitGatewayRouteTablePropagationsCommand;
}($Command));
export { GetTransitGatewayRouteTablePropagationsCommand };
