import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetReservedInstancesExchangeQuoteRequest, GetReservedInstancesExchangeQuoteResult } from "../models/models_5";
import { deserializeAws_ec2GetReservedInstancesExchangeQuoteCommand, serializeAws_ec2GetReservedInstancesExchangeQuoteCommand, } from "../protocols/Aws_ec2";
var GetReservedInstancesExchangeQuoteCommand = (function (_super) {
    __extends(GetReservedInstancesExchangeQuoteCommand, _super);
    function GetReservedInstancesExchangeQuoteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetReservedInstancesExchangeQuoteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetReservedInstancesExchangeQuoteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetReservedInstancesExchangeQuoteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetReservedInstancesExchangeQuoteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetReservedInstancesExchangeQuoteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetReservedInstancesExchangeQuoteCommand(input, context);
    };
    GetReservedInstancesExchangeQuoteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetReservedInstancesExchangeQuoteCommand(output, context);
    };
    return GetReservedInstancesExchangeQuoteCommand;
}($Command));
export { GetReservedInstancesExchangeQuoteCommand };
