import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetLaunchTemplateDataRequest } from "../models/models_4";
import { GetLaunchTemplateDataResult } from "../models/models_5";
import { deserializeAws_ec2GetLaunchTemplateDataCommand, serializeAws_ec2GetLaunchTemplateDataCommand, } from "../protocols/Aws_ec2";
var GetLaunchTemplateDataCommand = (function (_super) {
    __extends(GetLaunchTemplateDataCommand, _super);
    function GetLaunchTemplateDataCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetLaunchTemplateDataCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetLaunchTemplateDataCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetLaunchTemplateDataRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetLaunchTemplateDataResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetLaunchTemplateDataCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetLaunchTemplateDataCommand(input, context);
    };
    GetLaunchTemplateDataCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetLaunchTemplateDataCommand(output, context);
    };
    return GetLaunchTemplateDataCommand;
}($Command));
export { GetLaunchTemplateDataCommand };
