import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetIpamResourceCidrsRequest, GetIpamResourceCidrsResult } from "../models/models_4";
import { deserializeAws_ec2GetIpamResourceCidrsCommand, serializeAws_ec2GetIpamResourceCidrsCommand, } from "../protocols/Aws_ec2";
var GetIpamResourceCidrsCommand = (function (_super) {
    __extends(GetIpamResourceCidrsCommand, _super);
    function GetIpamResourceCidrsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetIpamResourceCidrsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetIpamResourceCidrsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetIpamResourceCidrsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetIpamResourceCidrsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetIpamResourceCidrsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetIpamResourceCidrsCommand(input, context);
    };
    GetIpamResourceCidrsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetIpamResourceCidrsCommand(output, context);
    };
    return GetIpamResourceCidrsCommand;
}($Command));
export { GetIpamResourceCidrsCommand };
