import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetIpamPoolAllocationsRequest, GetIpamPoolAllocationsResult } from "../models/models_4";
import { deserializeAws_ec2GetIpamPoolAllocationsCommand, serializeAws_ec2GetIpamPoolAllocationsCommand, } from "../protocols/Aws_ec2";
var GetIpamPoolAllocationsCommand = (function (_super) {
    __extends(GetIpamPoolAllocationsCommand, _super);
    function GetIpamPoolAllocationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetIpamPoolAllocationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetIpamPoolAllocationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetIpamPoolAllocationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetIpamPoolAllocationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetIpamPoolAllocationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetIpamPoolAllocationsCommand(input, context);
    };
    GetIpamPoolAllocationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetIpamPoolAllocationsCommand(output, context);
    };
    return GetIpamPoolAllocationsCommand;
}($Command));
export { GetIpamPoolAllocationsCommand };
