import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetEbsEncryptionByDefaultRequest, GetEbsEncryptionByDefaultResult } from "../models/models_4";
import { deserializeAws_ec2GetEbsEncryptionByDefaultCommand, serializeAws_ec2GetEbsEncryptionByDefaultCommand, } from "../protocols/Aws_ec2";
var GetEbsEncryptionByDefaultCommand = (function (_super) {
    __extends(GetEbsEncryptionByDefaultCommand, _super);
    function GetEbsEncryptionByDefaultCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetEbsEncryptionByDefaultCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetEbsEncryptionByDefaultCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetEbsEncryptionByDefaultRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetEbsEncryptionByDefaultResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetEbsEncryptionByDefaultCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetEbsEncryptionByDefaultCommand(input, context);
    };
    GetEbsEncryptionByDefaultCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetEbsEncryptionByDefaultCommand(output, context);
    };
    return GetEbsEncryptionByDefaultCommand;
}($Command));
export { GetEbsEncryptionByDefaultCommand };
