import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetAssociatedIpv6PoolCidrsRequest, GetAssociatedIpv6PoolCidrsResult } from "../models/models_4";
import { deserializeAws_ec2GetAssociatedIpv6PoolCidrsCommand, serializeAws_ec2GetAssociatedIpv6PoolCidrsCommand, } from "../protocols/Aws_ec2";
var GetAssociatedIpv6PoolCidrsCommand = (function (_super) {
    __extends(GetAssociatedIpv6PoolCidrsCommand, _super);
    function GetAssociatedIpv6PoolCidrsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetAssociatedIpv6PoolCidrsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetAssociatedIpv6PoolCidrsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetAssociatedIpv6PoolCidrsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetAssociatedIpv6PoolCidrsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetAssociatedIpv6PoolCidrsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetAssociatedIpv6PoolCidrsCommand(input, context);
    };
    GetAssociatedIpv6PoolCidrsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetAssociatedIpv6PoolCidrsCommand(output, context);
    };
    return GetAssociatedIpv6PoolCidrsCommand;
}($Command));
export { GetAssociatedIpv6PoolCidrsCommand };
