import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetAssociatedEnclaveCertificateIamRolesRequest, GetAssociatedEnclaveCertificateIamRolesResult, } from "../models/models_4";
import { deserializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommand, serializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommand, } from "../protocols/Aws_ec2";
var GetAssociatedEnclaveCertificateIamRolesCommand = (function (_super) {
    __extends(GetAssociatedEnclaveCertificateIamRolesCommand, _super);
    function GetAssociatedEnclaveCertificateIamRolesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetAssociatedEnclaveCertificateIamRolesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetAssociatedEnclaveCertificateIamRolesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetAssociatedEnclaveCertificateIamRolesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetAssociatedEnclaveCertificateIamRolesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetAssociatedEnclaveCertificateIamRolesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommand(input, context);
    };
    GetAssociatedEnclaveCertificateIamRolesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommand(output, context);
    };
    return GetAssociatedEnclaveCertificateIamRolesCommand;
}($Command));
export { GetAssociatedEnclaveCertificateIamRolesCommand };
