import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ExportImageRequest, ExportImageResult } from "../models/models_4";
import { deserializeAws_ec2ExportImageCommand, serializeAws_ec2ExportImageCommand } from "../protocols/Aws_ec2";
var ExportImageCommand = (function (_super) {
    __extends(ExportImageCommand, _super);
    function ExportImageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ExportImageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ExportImageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ExportImageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ExportImageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ExportImageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ExportImageCommand(input, context);
    };
    ExportImageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ExportImageCommand(output, context);
    };
    return ExportImageCommand;
}($Command));
export { ExportImageCommand };
