import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ExportClientVpnClientCertificateRevocationListRequest, ExportClientVpnClientCertificateRevocationListResult, } from "../models/models_4";
import { deserializeAws_ec2ExportClientVpnClientCertificateRevocationListCommand, serializeAws_ec2ExportClientVpnClientCertificateRevocationListCommand, } from "../protocols/Aws_ec2";
var ExportClientVpnClientCertificateRevocationListCommand = (function (_super) {
    __extends(ExportClientVpnClientCertificateRevocationListCommand, _super);
    function ExportClientVpnClientCertificateRevocationListCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ExportClientVpnClientCertificateRevocationListCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ExportClientVpnClientCertificateRevocationListCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ExportClientVpnClientCertificateRevocationListRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ExportClientVpnClientCertificateRevocationListResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ExportClientVpnClientCertificateRevocationListCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ExportClientVpnClientCertificateRevocationListCommand(input, context);
    };
    ExportClientVpnClientCertificateRevocationListCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ExportClientVpnClientCertificateRevocationListCommand(output, context);
    };
    return ExportClientVpnClientCertificateRevocationListCommand;
}($Command));
export { ExportClientVpnClientCertificateRevocationListCommand };
