import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableVpcClassicLinkDnsSupportRequest, EnableVpcClassicLinkDnsSupportResult } from "../models/models_4";
import { deserializeAws_ec2EnableVpcClassicLinkDnsSupportCommand, serializeAws_ec2EnableVpcClassicLinkDnsSupportCommand, } from "../protocols/Aws_ec2";
var EnableVpcClassicLinkDnsSupportCommand = (function (_super) {
    __extends(EnableVpcClassicLinkDnsSupportCommand, _super);
    function EnableVpcClassicLinkDnsSupportCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableVpcClassicLinkDnsSupportCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableVpcClassicLinkDnsSupportCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableVpcClassicLinkDnsSupportRequest.filterSensitiveLog,
            outputFilterSensitiveLog: EnableVpcClassicLinkDnsSupportResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableVpcClassicLinkDnsSupportCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableVpcClassicLinkDnsSupportCommand(input, context);
    };
    EnableVpcClassicLinkDnsSupportCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableVpcClassicLinkDnsSupportCommand(output, context);
    };
    return EnableVpcClassicLinkDnsSupportCommand;
}($Command));
export { EnableVpcClassicLinkDnsSupportCommand };
