import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableVolumeIORequest } from "../models/models_4";
import { deserializeAws_ec2EnableVolumeIOCommand, serializeAws_ec2EnableVolumeIOCommand } from "../protocols/Aws_ec2";
var EnableVolumeIOCommand = (function (_super) {
    __extends(EnableVolumeIOCommand, _super);
    function EnableVolumeIOCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableVolumeIOCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableVolumeIOCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableVolumeIORequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableVolumeIOCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableVolumeIOCommand(input, context);
    };
    EnableVolumeIOCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableVolumeIOCommand(output, context);
    };
    return EnableVolumeIOCommand;
}($Command));
export { EnableVolumeIOCommand };
