import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableTransitGatewayRouteTablePropagationRequest, EnableTransitGatewayRouteTablePropagationResult, } from "../models/models_4";
import { deserializeAws_ec2EnableTransitGatewayRouteTablePropagationCommand, serializeAws_ec2EnableTransitGatewayRouteTablePropagationCommand, } from "../protocols/Aws_ec2";
var EnableTransitGatewayRouteTablePropagationCommand = (function (_super) {
    __extends(EnableTransitGatewayRouteTablePropagationCommand, _super);
    function EnableTransitGatewayRouteTablePropagationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableTransitGatewayRouteTablePropagationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableTransitGatewayRouteTablePropagationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableTransitGatewayRouteTablePropagationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: EnableTransitGatewayRouteTablePropagationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableTransitGatewayRouteTablePropagationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableTransitGatewayRouteTablePropagationCommand(input, context);
    };
    EnableTransitGatewayRouteTablePropagationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableTransitGatewayRouteTablePropagationCommand(output, context);
    };
    return EnableTransitGatewayRouteTablePropagationCommand;
}($Command));
export { EnableTransitGatewayRouteTablePropagationCommand };
