import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableSerialConsoleAccessRequest, EnableSerialConsoleAccessResult } from "../models/models_4";
import { deserializeAws_ec2EnableSerialConsoleAccessCommand, serializeAws_ec2EnableSerialConsoleAccessCommand, } from "../protocols/Aws_ec2";
var EnableSerialConsoleAccessCommand = (function (_super) {
    __extends(EnableSerialConsoleAccessCommand, _super);
    function EnableSerialConsoleAccessCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableSerialConsoleAccessCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableSerialConsoleAccessCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableSerialConsoleAccessRequest.filterSensitiveLog,
            outputFilterSensitiveLog: EnableSerialConsoleAccessResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableSerialConsoleAccessCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableSerialConsoleAccessCommand(input, context);
    };
    EnableSerialConsoleAccessCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableSerialConsoleAccessCommand(output, context);
    };
    return EnableSerialConsoleAccessCommand;
}($Command));
export { EnableSerialConsoleAccessCommand };
