import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableIpamOrganizationAdminAccountRequest, EnableIpamOrganizationAdminAccountResult, } from "../models/models_4";
import { deserializeAws_ec2EnableIpamOrganizationAdminAccountCommand, serializeAws_ec2EnableIpamOrganizationAdminAccountCommand, } from "../protocols/Aws_ec2";
var EnableIpamOrganizationAdminAccountCommand = (function (_super) {
    __extends(EnableIpamOrganizationAdminAccountCommand, _super);
    function EnableIpamOrganizationAdminAccountCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableIpamOrganizationAdminAccountCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableIpamOrganizationAdminAccountCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableIpamOrganizationAdminAccountRequest.filterSensitiveLog,
            outputFilterSensitiveLog: EnableIpamOrganizationAdminAccountResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableIpamOrganizationAdminAccountCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableIpamOrganizationAdminAccountCommand(input, context);
    };
    EnableIpamOrganizationAdminAccountCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableIpamOrganizationAdminAccountCommand(output, context);
    };
    return EnableIpamOrganizationAdminAccountCommand;
}($Command));
export { EnableIpamOrganizationAdminAccountCommand };
