import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableFastSnapshotRestoresRequest, EnableFastSnapshotRestoresResult } from "../models/models_4";
import { deserializeAws_ec2EnableFastSnapshotRestoresCommand, serializeAws_ec2EnableFastSnapshotRestoresCommand, } from "../protocols/Aws_ec2";
var EnableFastSnapshotRestoresCommand = (function (_super) {
    __extends(EnableFastSnapshotRestoresCommand, _super);
    function EnableFastSnapshotRestoresCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableFastSnapshotRestoresCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableFastSnapshotRestoresCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableFastSnapshotRestoresRequest.filterSensitiveLog,
            outputFilterSensitiveLog: EnableFastSnapshotRestoresResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableFastSnapshotRestoresCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableFastSnapshotRestoresCommand(input, context);
    };
    EnableFastSnapshotRestoresCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableFastSnapshotRestoresCommand(output, context);
    };
    return EnableFastSnapshotRestoresCommand;
}($Command));
export { EnableFastSnapshotRestoresCommand };
