import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { EnableEbsEncryptionByDefaultRequest, EnableEbsEncryptionByDefaultResult } from "../models/models_4";
import { deserializeAws_ec2EnableEbsEncryptionByDefaultCommand, serializeAws_ec2EnableEbsEncryptionByDefaultCommand, } from "../protocols/Aws_ec2";
var EnableEbsEncryptionByDefaultCommand = (function (_super) {
    __extends(EnableEbsEncryptionByDefaultCommand, _super);
    function EnableEbsEncryptionByDefaultCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    EnableEbsEncryptionByDefaultCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "EnableEbsEncryptionByDefaultCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: EnableEbsEncryptionByDefaultRequest.filterSensitiveLog,
            outputFilterSensitiveLog: EnableEbsEncryptionByDefaultResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    EnableEbsEncryptionByDefaultCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2EnableEbsEncryptionByDefaultCommand(input, context);
    };
    EnableEbsEncryptionByDefaultCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2EnableEbsEncryptionByDefaultCommand(output, context);
    };
    return EnableEbsEncryptionByDefaultCommand;
}($Command));
export { EnableEbsEncryptionByDefaultCommand };
