import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateTransitGatewayRouteTableRequest, DisassociateTransitGatewayRouteTableResult, } from "../models/models_4";
import { deserializeAws_ec2DisassociateTransitGatewayRouteTableCommand, serializeAws_ec2DisassociateTransitGatewayRouteTableCommand, } from "../protocols/Aws_ec2";
var DisassociateTransitGatewayRouteTableCommand = (function (_super) {
    __extends(DisassociateTransitGatewayRouteTableCommand, _super);
    function DisassociateTransitGatewayRouteTableCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateTransitGatewayRouteTableCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateTransitGatewayRouteTableCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateTransitGatewayRouteTableRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateTransitGatewayRouteTableResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateTransitGatewayRouteTableCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateTransitGatewayRouteTableCommand(input, context);
    };
    DisassociateTransitGatewayRouteTableCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateTransitGatewayRouteTableCommand(output, context);
    };
    return DisassociateTransitGatewayRouteTableCommand;
}($Command));
export { DisassociateTransitGatewayRouteTableCommand };
