import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateSubnetCidrBlockRequest, DisassociateSubnetCidrBlockResult } from "../models/models_4";
import { deserializeAws_ec2DisassociateSubnetCidrBlockCommand, serializeAws_ec2DisassociateSubnetCidrBlockCommand, } from "../protocols/Aws_ec2";
var DisassociateSubnetCidrBlockCommand = (function (_super) {
    __extends(DisassociateSubnetCidrBlockCommand, _super);
    function DisassociateSubnetCidrBlockCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateSubnetCidrBlockCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateSubnetCidrBlockCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateSubnetCidrBlockRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateSubnetCidrBlockResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateSubnetCidrBlockCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateSubnetCidrBlockCommand(input, context);
    };
    DisassociateSubnetCidrBlockCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateSubnetCidrBlockCommand(output, context);
    };
    return DisassociateSubnetCidrBlockCommand;
}($Command));
export { DisassociateSubnetCidrBlockCommand };
