import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociateIamInstanceProfileRequest, DisassociateIamInstanceProfileResult } from "../models/models_4";
import { deserializeAws_ec2DisassociateIamInstanceProfileCommand, serializeAws_ec2DisassociateIamInstanceProfileCommand, } from "../protocols/Aws_ec2";
var DisassociateIamInstanceProfileCommand = (function (_super) {
    __extends(DisassociateIamInstanceProfileCommand, _super);
    function DisassociateIamInstanceProfileCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisassociateIamInstanceProfileCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisassociateIamInstanceProfileCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisassociateIamInstanceProfileRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisassociateIamInstanceProfileResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisassociateIamInstanceProfileCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisassociateIamInstanceProfileCommand(input, context);
    };
    DisassociateIamInstanceProfileCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisassociateIamInstanceProfileCommand(output, context);
    };
    return DisassociateIamInstanceProfileCommand;
}($Command));
export { DisassociateIamInstanceProfileCommand };
