import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisableTransitGatewayRouteTablePropagationRequest, DisableTransitGatewayRouteTablePropagationResult, } from "../models/models_4";
import { deserializeAws_ec2DisableTransitGatewayRouteTablePropagationCommand, serializeAws_ec2DisableTransitGatewayRouteTablePropagationCommand, } from "../protocols/Aws_ec2";
var DisableTransitGatewayRouteTablePropagationCommand = (function (_super) {
    __extends(DisableTransitGatewayRouteTablePropagationCommand, _super);
    function DisableTransitGatewayRouteTablePropagationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DisableTransitGatewayRouteTablePropagationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DisableTransitGatewayRouteTablePropagationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DisableTransitGatewayRouteTablePropagationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DisableTransitGatewayRouteTablePropagationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DisableTransitGatewayRouteTablePropagationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DisableTransitGatewayRouteTablePropagationCommand(input, context);
    };
    DisableTransitGatewayRouteTablePropagationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DisableTransitGatewayRouteTablePropagationCommand(output, context);
    };
    return DisableTransitGatewayRouteTablePropagationCommand;
}($Command));
export { DisableTransitGatewayRouteTablePropagationCommand };
