import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { VolumeAttachment } from "../models/models_0";
import { DetachVolumeRequest } from "../models/models_4";
import { deserializeAws_ec2DetachVolumeCommand, serializeAws_ec2DetachVolumeCommand } from "../protocols/Aws_ec2";
var DetachVolumeCommand = (function (_super) {
    __extends(DetachVolumeCommand, _super);
    function DetachVolumeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DetachVolumeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DetachVolumeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DetachVolumeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: VolumeAttachment.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DetachVolumeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DetachVolumeCommand(input, context);
    };
    DetachVolumeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DetachVolumeCommand(output, context);
    };
    return DetachVolumeCommand;
}($Command));
export { DetachVolumeCommand };
