import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DetachNetworkInterfaceRequest } from "../models/models_4";
import { deserializeAws_ec2DetachNetworkInterfaceCommand, serializeAws_ec2DetachNetworkInterfaceCommand, } from "../protocols/Aws_ec2";
var DetachNetworkInterfaceCommand = (function (_super) {
    __extends(DetachNetworkInterfaceCommand, _super);
    function DetachNetworkInterfaceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DetachNetworkInterfaceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DetachNetworkInterfaceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DetachNetworkInterfaceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DetachNetworkInterfaceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DetachNetworkInterfaceCommand(input, context);
    };
    DetachNetworkInterfaceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DetachNetworkInterfaceCommand(output, context);
    };
    return DetachNetworkInterfaceCommand;
}($Command));
export { DetachNetworkInterfaceCommand };
