import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpnConnectionsRequest, DescribeVpnConnectionsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVpnConnectionsCommand, serializeAws_ec2DescribeVpnConnectionsCommand, } from "../protocols/Aws_ec2";
var DescribeVpnConnectionsCommand = (function (_super) {
    __extends(DescribeVpnConnectionsCommand, _super);
    function DescribeVpnConnectionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpnConnectionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpnConnectionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpnConnectionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpnConnectionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpnConnectionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpnConnectionsCommand(input, context);
    };
    DescribeVpnConnectionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpnConnectionsCommand(output, context);
    };
    return DescribeVpnConnectionsCommand;
}($Command));
export { DescribeVpnConnectionsCommand };
