import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcPeeringConnectionsCommand, serializeAws_ec2DescribeVpcPeeringConnectionsCommand, } from "../protocols/Aws_ec2";
var DescribeVpcPeeringConnectionsCommand = (function (_super) {
    __extends(DescribeVpcPeeringConnectionsCommand, _super);
    function DescribeVpcPeeringConnectionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcPeeringConnectionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcPeeringConnectionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcPeeringConnectionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcPeeringConnectionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcPeeringConnectionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcPeeringConnectionsCommand(input, context);
    };
    DescribeVpcPeeringConnectionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcPeeringConnectionsCommand(output, context);
    };
    return DescribeVpcPeeringConnectionsCommand;
}($Command));
export { DescribeVpcPeeringConnectionsCommand };
