import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcEndpointServicePermissionsRequest, DescribeVpcEndpointServicePermissionsResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcEndpointServicePermissionsCommand, serializeAws_ec2DescribeVpcEndpointServicePermissionsCommand, } from "../protocols/Aws_ec2";
var DescribeVpcEndpointServicePermissionsCommand = (function (_super) {
    __extends(DescribeVpcEndpointServicePermissionsCommand, _super);
    function DescribeVpcEndpointServicePermissionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcEndpointServicePermissionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcEndpointServicePermissionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcEndpointServicePermissionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcEndpointServicePermissionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcEndpointServicePermissionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcEndpointServicePermissionsCommand(input, context);
    };
    DescribeVpcEndpointServicePermissionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcEndpointServicePermissionsCommand(output, context);
    };
    return DescribeVpcEndpointServicePermissionsCommand;
}($Command));
export { DescribeVpcEndpointServicePermissionsCommand };
