import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVpcEndpointConnectionNotificationsRequest, DescribeVpcEndpointConnectionNotificationsResult, } from "../models/models_4";
import { deserializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommand, serializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommand, } from "../protocols/Aws_ec2";
var DescribeVpcEndpointConnectionNotificationsCommand = (function (_super) {
    __extends(DescribeVpcEndpointConnectionNotificationsCommand, _super);
    function DescribeVpcEndpointConnectionNotificationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVpcEndpointConnectionNotificationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVpcEndpointConnectionNotificationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVpcEndpointConnectionNotificationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVpcEndpointConnectionNotificationsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVpcEndpointConnectionNotificationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommand(input, context);
    };
    DescribeVpcEndpointConnectionNotificationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommand(output, context);
    };
    return DescribeVpcEndpointConnectionNotificationsCommand;
}($Command));
export { DescribeVpcEndpointConnectionNotificationsCommand };
