import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeVolumeAttributeRequest, DescribeVolumeAttributeResult } from "../models/models_4";
import { deserializeAws_ec2DescribeVolumeAttributeCommand, serializeAws_ec2DescribeVolumeAttributeCommand, } from "../protocols/Aws_ec2";
var DescribeVolumeAttributeCommand = (function (_super) {
    __extends(DescribeVolumeAttributeCommand, _super);
    function DescribeVolumeAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeVolumeAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeVolumeAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeVolumeAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeVolumeAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeVolumeAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeVolumeAttributeCommand(input, context);
    };
    DescribeVolumeAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeVolumeAttributeCommand(output, context);
    };
    return DescribeVolumeAttributeCommand;
}($Command));
export { DescribeVolumeAttributeCommand };
