import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewaysRequest, DescribeTransitGatewaysResult } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewaysCommand, serializeAws_ec2DescribeTransitGatewaysCommand, } from "../protocols/Aws_ec2";
var DescribeTransitGatewaysCommand = (function (_super) {
    __extends(DescribeTransitGatewaysCommand, _super);
    function DescribeTransitGatewaysCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTransitGatewaysCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTransitGatewaysCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTransitGatewaysRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewaysResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTransitGatewaysCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTransitGatewaysCommand(input, context);
    };
    DescribeTransitGatewaysCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTransitGatewaysCommand(output, context);
    };
    return DescribeTransitGatewaysCommand;
}($Command));
export { DescribeTransitGatewaysCommand };
