import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewayConnectsRequest, DescribeTransitGatewayConnectsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewayConnectsCommand, serializeAws_ec2DescribeTransitGatewayConnectsCommand, } from "../protocols/Aws_ec2";
var DescribeTransitGatewayConnectsCommand = (function (_super) {
    __extends(DescribeTransitGatewayConnectsCommand, _super);
    function DescribeTransitGatewayConnectsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTransitGatewayConnectsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTransitGatewayConnectsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTransitGatewayConnectsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewayConnectsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTransitGatewayConnectsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTransitGatewayConnectsCommand(input, context);
    };
    DescribeTransitGatewayConnectsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTransitGatewayConnectsCommand(output, context);
    };
    return DescribeTransitGatewayConnectsCommand;
}($Command));
export { DescribeTransitGatewayConnectsCommand };
