import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTrafficMirrorTargetsRequest, DescribeTrafficMirrorTargetsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeTrafficMirrorTargetsCommand, serializeAws_ec2DescribeTrafficMirrorTargetsCommand, } from "../protocols/Aws_ec2";
var DescribeTrafficMirrorTargetsCommand = (function (_super) {
    __extends(DescribeTrafficMirrorTargetsCommand, _super);
    function DescribeTrafficMirrorTargetsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeTrafficMirrorTargetsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeTrafficMirrorTargetsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeTrafficMirrorTargetsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeTrafficMirrorTargetsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeTrafficMirrorTargetsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeTrafficMirrorTargetsCommand(input, context);
    };
    DescribeTrafficMirrorTargetsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeTrafficMirrorTargetsCommand(output, context);
    };
    return DescribeTrafficMirrorTargetsCommand;
}($Command));
export { DescribeTrafficMirrorTargetsCommand };
