import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSubnetsRequest, DescribeSubnetsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSubnetsCommand, serializeAws_ec2DescribeSubnetsCommand } from "../protocols/Aws_ec2";
var DescribeSubnetsCommand = (function (_super) {
    __extends(DescribeSubnetsCommand, _super);
    function DescribeSubnetsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSubnetsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSubnetsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSubnetsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSubnetsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSubnetsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSubnetsCommand(input, context);
    };
    DescribeSubnetsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSubnetsCommand(output, context);
    };
    return DescribeSubnetsCommand;
}($Command));
export { DescribeSubnetsCommand };
