import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeStaleSecurityGroupsRequest, DescribeStaleSecurityGroupsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeStaleSecurityGroupsCommand, serializeAws_ec2DescribeStaleSecurityGroupsCommand, } from "../protocols/Aws_ec2";
var DescribeStaleSecurityGroupsCommand = (function (_super) {
    __extends(DescribeStaleSecurityGroupsCommand, _super);
    function DescribeStaleSecurityGroupsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeStaleSecurityGroupsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeStaleSecurityGroupsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeStaleSecurityGroupsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeStaleSecurityGroupsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeStaleSecurityGroupsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeStaleSecurityGroupsCommand(input, context);
    };
    DescribeStaleSecurityGroupsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeStaleSecurityGroupsCommand(output, context);
    };
    return DescribeStaleSecurityGroupsCommand;
}($Command));
export { DescribeStaleSecurityGroupsCommand };
