import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSpotInstanceRequestsCommand, serializeAws_ec2DescribeSpotInstanceRequestsCommand, } from "../protocols/Aws_ec2";
var DescribeSpotInstanceRequestsCommand = (function (_super) {
    __extends(DescribeSpotInstanceRequestsCommand, _super);
    function DescribeSpotInstanceRequestsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSpotInstanceRequestsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSpotInstanceRequestsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSpotInstanceRequestsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSpotInstanceRequestsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSpotInstanceRequestsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSpotInstanceRequestsCommand(input, context);
    };
    DescribeSpotInstanceRequestsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSpotInstanceRequestsCommand(output, context);
    };
    return DescribeSpotInstanceRequestsCommand;
}($Command));
export { DescribeSpotInstanceRequestsCommand };
