import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResponse } from "../models/models_4";
import { deserializeAws_ec2DescribeSpotFleetRequestsCommand, serializeAws_ec2DescribeSpotFleetRequestsCommand, } from "../protocols/Aws_ec2";
var DescribeSpotFleetRequestsCommand = (function (_super) {
    __extends(DescribeSpotFleetRequestsCommand, _super);
    function DescribeSpotFleetRequestsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSpotFleetRequestsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSpotFleetRequestsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSpotFleetRequestsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSpotFleetRequestsResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSpotFleetRequestsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSpotFleetRequestsCommand(input, context);
    };
    DescribeSpotFleetRequestsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSpotFleetRequestsCommand(output, context);
    };
    return DescribeSpotFleetRequestsCommand;
}($Command));
export { DescribeSpotFleetRequestsCommand };
