import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSpotFleetInstancesRequest, DescribeSpotFleetInstancesResponse } from "../models/models_4";
import { deserializeAws_ec2DescribeSpotFleetInstancesCommand, serializeAws_ec2DescribeSpotFleetInstancesCommand, } from "../protocols/Aws_ec2";
var DescribeSpotFleetInstancesCommand = (function (_super) {
    __extends(DescribeSpotFleetInstancesCommand, _super);
    function DescribeSpotFleetInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSpotFleetInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSpotFleetInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSpotFleetInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSpotFleetInstancesResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSpotFleetInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSpotFleetInstancesCommand(input, context);
    };
    DescribeSpotFleetInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSpotFleetInstancesCommand(output, context);
    };
    return DescribeSpotFleetInstancesCommand;
}($Command));
export { DescribeSpotFleetInstancesCommand };
