import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSpotDatafeedSubscriptionRequest, DescribeSpotDatafeedSubscriptionResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSpotDatafeedSubscriptionCommand, serializeAws_ec2DescribeSpotDatafeedSubscriptionCommand, } from "../protocols/Aws_ec2";
var DescribeSpotDatafeedSubscriptionCommand = (function (_super) {
    __extends(DescribeSpotDatafeedSubscriptionCommand, _super);
    function DescribeSpotDatafeedSubscriptionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSpotDatafeedSubscriptionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSpotDatafeedSubscriptionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSpotDatafeedSubscriptionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSpotDatafeedSubscriptionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSpotDatafeedSubscriptionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSpotDatafeedSubscriptionCommand(input, context);
    };
    DescribeSpotDatafeedSubscriptionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSpotDatafeedSubscriptionCommand(output, context);
    };
    return DescribeSpotDatafeedSubscriptionCommand;
}($Command));
export { DescribeSpotDatafeedSubscriptionCommand };
