import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSnapshotsRequest, DescribeSnapshotsResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSnapshotsCommand, serializeAws_ec2DescribeSnapshotsCommand, } from "../protocols/Aws_ec2";
var DescribeSnapshotsCommand = (function (_super) {
    __extends(DescribeSnapshotsCommand, _super);
    function DescribeSnapshotsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSnapshotsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSnapshotsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSnapshotsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSnapshotsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSnapshotsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSnapshotsCommand(input, context);
    };
    DescribeSnapshotsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSnapshotsCommand(output, context);
    };
    return DescribeSnapshotsCommand;
}($Command));
export { DescribeSnapshotsCommand };
