import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSnapshotTierStatusRequest, DescribeSnapshotTierStatusResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSnapshotTierStatusCommand, serializeAws_ec2DescribeSnapshotTierStatusCommand, } from "../protocols/Aws_ec2";
var DescribeSnapshotTierStatusCommand = (function (_super) {
    __extends(DescribeSnapshotTierStatusCommand, _super);
    function DescribeSnapshotTierStatusCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSnapshotTierStatusCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSnapshotTierStatusCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSnapshotTierStatusRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSnapshotTierStatusResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSnapshotTierStatusCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSnapshotTierStatusCommand(input, context);
    };
    DescribeSnapshotTierStatusCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSnapshotTierStatusCommand(output, context);
    };
    return DescribeSnapshotTierStatusCommand;
}($Command));
export { DescribeSnapshotTierStatusCommand };
