import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeSecurityGroupRulesRequest, DescribeSecurityGroupRulesResult } from "../models/models_4";
import { deserializeAws_ec2DescribeSecurityGroupRulesCommand, serializeAws_ec2DescribeSecurityGroupRulesCommand, } from "../protocols/Aws_ec2";
var DescribeSecurityGroupRulesCommand = (function (_super) {
    __extends(DescribeSecurityGroupRulesCommand, _super);
    function DescribeSecurityGroupRulesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeSecurityGroupRulesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeSecurityGroupRulesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeSecurityGroupRulesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeSecurityGroupRulesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeSecurityGroupRulesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeSecurityGroupRulesCommand(input, context);
    };
    DescribeSecurityGroupRulesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeSecurityGroupRulesCommand(output, context);
    };
    return DescribeSecurityGroupRulesCommand;
}($Command));
export { DescribeSecurityGroupRulesCommand };
