import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeScheduledInstancesRequest, DescribeScheduledInstancesResult } from "../models/models_4";
import { deserializeAws_ec2DescribeScheduledInstancesCommand, serializeAws_ec2DescribeScheduledInstancesCommand, } from "../protocols/Aws_ec2";
var DescribeScheduledInstancesCommand = (function (_super) {
    __extends(DescribeScheduledInstancesCommand, _super);
    function DescribeScheduledInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeScheduledInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeScheduledInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeScheduledInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeScheduledInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeScheduledInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeScheduledInstancesCommand(input, context);
    };
    DescribeScheduledInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeScheduledInstancesCommand(output, context);
    };
    return DescribeScheduledInstancesCommand;
}($Command));
export { DescribeScheduledInstancesCommand };
