import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeReservedInstancesListingsRequest, DescribeReservedInstancesListingsResult } from "../models/models_3";
import { deserializeAws_ec2DescribeReservedInstancesListingsCommand, serializeAws_ec2DescribeReservedInstancesListingsCommand, } from "../protocols/Aws_ec2";
var DescribeReservedInstancesListingsCommand = (function (_super) {
    __extends(DescribeReservedInstancesListingsCommand, _super);
    function DescribeReservedInstancesListingsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeReservedInstancesListingsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeReservedInstancesListingsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeReservedInstancesListingsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeReservedInstancesListingsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeReservedInstancesListingsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeReservedInstancesListingsCommand(input, context);
    };
    DescribeReservedInstancesListingsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeReservedInstancesListingsCommand(output, context);
    };
    return DescribeReservedInstancesListingsCommand;
}($Command));
export { DescribeReservedInstancesListingsCommand };
