import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeReservedInstancesRequest, DescribeReservedInstancesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeReservedInstancesCommand, serializeAws_ec2DescribeReservedInstancesCommand, } from "../protocols/Aws_ec2";
var DescribeReservedInstancesCommand = (function (_super) {
    __extends(DescribeReservedInstancesCommand, _super);
    function DescribeReservedInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeReservedInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeReservedInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeReservedInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeReservedInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeReservedInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeReservedInstancesCommand(input, context);
    };
    DescribeReservedInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeReservedInstancesCommand(output, context);
    };
    return DescribeReservedInstancesCommand;
}($Command));
export { DescribeReservedInstancesCommand };
