import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribePlacementGroupsRequest, DescribePlacementGroupsResult } from "../models/models_3";
import { deserializeAws_ec2DescribePlacementGroupsCommand, serializeAws_ec2DescribePlacementGroupsCommand, } from "../protocols/Aws_ec2";
var DescribePlacementGroupsCommand = (function (_super) {
    __extends(DescribePlacementGroupsCommand, _super);
    function DescribePlacementGroupsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribePlacementGroupsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribePlacementGroupsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribePlacementGroupsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribePlacementGroupsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribePlacementGroupsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribePlacementGroupsCommand(input, context);
    };
    DescribePlacementGroupsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribePlacementGroupsCommand(output, context);
    };
    return DescribePlacementGroupsCommand;
}($Command));
export { DescribePlacementGroupsCommand };
