import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeNetworkInterfacesCommand, serializeAws_ec2DescribeNetworkInterfacesCommand, } from "../protocols/Aws_ec2";
var DescribeNetworkInterfacesCommand = (function (_super) {
    __extends(DescribeNetworkInterfacesCommand, _super);
    function DescribeNetworkInterfacesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNetworkInterfacesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNetworkInterfacesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNetworkInterfacesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNetworkInterfacesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNetworkInterfacesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNetworkInterfacesCommand(input, context);
    };
    DescribeNetworkInterfacesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNetworkInterfacesCommand(output, context);
    };
    return DescribeNetworkInterfacesCommand;
}($Command));
export { DescribeNetworkInterfacesCommand };
