import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNetworkInsightsAnalysesRequest, DescribeNetworkInsightsAnalysesResult } from "../models/models_3";
import { deserializeAws_ec2DescribeNetworkInsightsAnalysesCommand, serializeAws_ec2DescribeNetworkInsightsAnalysesCommand, } from "../protocols/Aws_ec2";
var DescribeNetworkInsightsAnalysesCommand = (function (_super) {
    __extends(DescribeNetworkInsightsAnalysesCommand, _super);
    function DescribeNetworkInsightsAnalysesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNetworkInsightsAnalysesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNetworkInsightsAnalysesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNetworkInsightsAnalysesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNetworkInsightsAnalysesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNetworkInsightsAnalysesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNetworkInsightsAnalysesCommand(input, context);
    };
    DescribeNetworkInsightsAnalysesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNetworkInsightsAnalysesCommand(output, context);
    };
    return DescribeNetworkInsightsAnalysesCommand;
}($Command));
export { DescribeNetworkInsightsAnalysesCommand };
