import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeNatGatewaysRequest, DescribeNatGatewaysResult } from "../models/models_3";
import { deserializeAws_ec2DescribeNatGatewaysCommand, serializeAws_ec2DescribeNatGatewaysCommand, } from "../protocols/Aws_ec2";
var DescribeNatGatewaysCommand = (function (_super) {
    __extends(DescribeNatGatewaysCommand, _super);
    function DescribeNatGatewaysCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeNatGatewaysCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "DescribeNatGatewaysCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeNatGatewaysRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeNatGatewaysResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeNatGatewaysCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2DescribeNatGatewaysCommand(input, context);
    };
    DescribeNatGatewaysCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2DescribeNatGatewaysCommand(output, context);
    };
    return DescribeNatGatewaysCommand;
}($Command));
export { DescribeNatGatewaysCommand };
